clc;
close all;
%% Load 10 identical simulated ATS fine crackles here 
load SF1_ATS
load SF2_ATS
load SF3_ATS
load SF4_ATS
load SF5_ATS
load SF6_ATS
load SF7_ATS
load SF8_ATS
load SF9_ATS
load SF10_ATS
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SF1_ATS         = [zeros(1,1000),SF1_ATS,zeros(1,Signal_length-(1000+length(SF1_ATS)))];
SF2_ATS         = [zeros(1,3000),SF2_ATS,zeros(1,Signal_length-(3000+length(SF2_ATS)))];
SF3_ATS         = [zeros(1,7000),SF3_ATS,zeros(1,Signal_length-(7000+length(SF3_ATS)))];
SF4_ATS         = [zeros(1,12000),SF4_ATS,zeros(1,Signal_length-(12000+length(SF4_ATS)))];
SF5_ATS         = [zeros(1,14000),SF5_ATS,zeros(1,Signal_length-(14000+length(SF5_ATS)))];
SF6_ATS         = [zeros(1,17000),SF6_ATS,zeros(1,Signal_length-(17000+length(SF6_ATS)))];
SF7_ATS         = [zeros(1,20000),SF7_ATS,zeros(1,Signal_length-(20000+length(SF7_ATS)))];
SF8_ATS         = [zeros(1,23000),SF8_ATS,zeros(1,Signal_length-(23000+length(SF8_ATS)))];
SF9_ATS         = [zeros(1,27500),SF9_ATS,zeros(1,Signal_length-(27500+length(SF9_ATS)))];
SF10_ATS        = [zeros(1,30000),SF10_ATS,zeros(1,Signal_length-(30000+length(SF10_ATS)))];
Ten_identical_simulated_ATS_fine_crackles       = SF1_ATS+SF2_ATS+SF3_ATS+SF4_ATS+SF5_ATS+SF6_ATS+SF7_ATS+SF8_ATS+SF9_ATS+SF10_ATS;
Ten_identical_simulated_ATS_fine_crackles       = Ten_identical_simulated_ATS_fine_crackles(1:end);
%% Plot
figure
plot(Ten_identical_simulated_ATS_fine_crackles,'k');
xlabel('Number of samples','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
text(1150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
%%
text(250,.85,'SF1-ATS','fontsize',8,'FontWeight','bold')
text(3150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(3150,.85,'SF2-ATS','fontsize',8,'FontWeight','bold')
text(7150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(7000,.85,'SF3-ATS','fontsize',8,'FontWeight','bold')
text(12150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(11150,.85,'SF4-ATS','fontsize',8,'FontWeight','bold')
text(14150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(14150,.85,'SF5-ATS','fontsize',8,'FontWeight','bold')
text(17150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(17150,.85,'SF6-ATS','fontsize',8,'FontWeight','bold')
text(20150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(20150,.85,'SF7-ATS','fontsize',8,'FontWeight','bold')
text(23150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(23150,.85,'SF8-ATS','fontsize',8,'FontWeight','bold')
text(27650,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(26500,.85,'SF9-ATS','fontsize',8,'FontWeight','bold')
text(30150,.75,'\downarrow','fontsize',12,'FontWeight','bold')
text(29800,.85,'SF10-ATS','fontsize',8,'FontWeight','bold')
%%
set(gcf, 'Position',  [100, 300, 800, 300])
title('10 identical simulated ATS fine crackles','FontSize',12,'FontName','Times New Roman','fontweight','bold');
xlim([0 Signal_length]);
ylim([-1 1]);
